Dim strComputer, osVersion, osArch, osName

'Get OS Version
strComputer = "." 
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\CIMV2") 
Set colItems = objWMIService.ExecQuery("SELECT * FROM Win32_OperatingSystem",,48) 
For Each objItem in colItems 
	osVersion = Split(objItem.Version, ".")
	osName = objItem.Caption
Next

'Get OS Architecture
Set shell = CreateObject("Wscript.Shell")
osArch = shell.ExpandEnvironmentStrings("%PROCESSOR_ARCHITECTURE%")
Set shell = Nothing

Call RunInstaller(osVersion, osArch, osName)

Sub RunInstaller(osVersion, osArch, osName)
	Dim regEx, chkStr
	Set regEx = New RegExp
	'chkStr = "32"
	'regEx.Pattern = Left(osArch(0),2)
	chkStr = "x86"
	regEx.Pattern = osArch

	Set oShell = CreateObject("WScript.Shell")
	Select Case osVersion(0)
		Case 5
			If regEx.Test(chkStr) Then
				oShell.Run ".\XP" & "\setup_winXP_x86.exe",1,false
			Else
				Wscript.Echo "*** Illegal environment. ***"
			End If
		Case 6
			Select Case osVersion(1)
				Case 0
					'Windows Vista
					Wscript.Echo "*** Illegal environment. ***"
				Case 1
					If regEx.Test(chkStr) Then
						oShell.Run ".\7" & "\setup_win7_x86.exe",1,false
					Else
						oShell.Run ".\7" & "\setup_win7_x64.exe",1,false
					End If
				Case Else
					If regEx.Test(chkStr) Then
						oShell.Run ".\8" & "\setup_win8_x86.exe",1,false
					Else
						oShell.Run ".\8" & "\setup_win8_x64.exe",1,false
					End If
			End Select
		Case 10
			If IsTargetOSName("Windows 10", osName) Then
				If regEx.Test(chkStr) Then
					oShell.Run ".\10" & "\setup_win10_x86.exe",1,false
				Else
					oShell.Run ".\10" & "\setup_win10_x64.exe",1,false
				End If
			ElseIf IsTargetOSName("Windows 11", osName) Then
				If regEx.Test(chkStr) Then
					Wscript.Echo "*** Illegal environment. ***"
				Else
					oShell.Run ".\11" & "\setup_win11_x64.exe",1,false
				End If
			Else
				Wscript.Echo "*** Illegal environment. ***"
			End If
		Case Else
			Wscript.Echo "*** Illegal environment. ***"
	End Select

	Set oShell = Nothing

End Sub

Function IsTargetOSName(sTargetName, osName)
	Dim regEx, chkStr
	Set regEx = New RegExp
	regEx.Pattern = sTargetName
	
	IsTargetOSName = regEx.Test(osName)

	Set regEx = Nothing
End Function

